
// Glenn's Shapes POV-Ray Include File
// first concept 2-June-97
// last update 25-Oct-99
//
// Copyright 1997-2005 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
//
// This file does not render.  #include "GShapes.inc" in another .pov file
//
// A collection of various shapes
//     RoundedBox
//
// Uses RH coordinate reference system


//===============================================
//             Textures
//===============================================


//===============================================
//       Objects
//===============================================

// --------- Rounded Box --------------
// copy this to your .pov file:
// #declare Roundness = .3 // range 0 to .5, larger = more rounded
// object { RoundedBox }

// The default size is always 1x 1y 1z, regardless of
// the Roundness factor.

// set defaults
#ifndef ( Roundness )
#declare Roundness = .2
#end

#declare RA = Roundness/2 // sph/cyl rads
#declare RB = .5-Roundness/2 // higher roundness = smaller sph/cyl centers

#declare RoundedBox =
	union {
		box { <-RB,-RB,-.5>,<RB,RB,.5> }
		box { <-RB,-.5,-RB>,<RB,.5,RB> }
		box { <-.5,-RB,-RB>,<.5,RB,RB> }

		sphere { <-RB,-RB,-RB>, RA }
		sphere { < RB,-RB,-RB>, RA }
		sphere { <-RB, RB,-RB>, RA }
		sphere { <-RB,-RB, RB>, RA }

		sphere { < RB, RB,-RB>, RA }
		sphere { < RB,-RB, RB>, RA }
		sphere { <-RB, RB, RB>, RA }
		sphere { < RB, RB, RB>, RA }

		cylinder { <-RB,-RB,-RB>,<-RB,-RB, RB>,RA }
		cylinder { <-RB, RB,-RB>,<-RB, RB, RB>,RA }
		cylinder { < RB,-RB,-RB>,< RB,-RB, RB>,RA }
		cylinder { < RB, RB,-RB>,< RB, RB, RB>,RA }

		cylinder { <-RB,-RB,-RB>,<-RB, RB,-RB>,RA }
		cylinder { < RB,-RB,-RB>,< RB, RB,-RB>,RA }
		cylinder { <-RB,-RB, RB>,<-RB, RB, RB>,RA }
		cylinder { < RB,-RB, RB>,< RB, RB, RB>,RA }

		cylinder { <-RB,-RB,-RB>,< RB,-RB,-RB>,RA }
		cylinder { <-RB, RB,-RB>,< RB, RB,-RB>,RA }
		cylinder { <-RB,-RB, RB>,< RB,-RB, RB>,RA }
		cylinder { <-RB, RB, RB>,< RB, RB, RB>,RA }
	}



